#include <stdio.h>
#include "callfdk_c.h"

#include "svc2106.h"

int
main()
{
	CallFdk_Error tError;
	TMsg *pIn = NULL;
	TMsg *pOut = NULL;
	TMsg *pSub = NULL;
	TMsg *pAmort = NULL;
	int i;
	int iRet;
	int iArrSize;
	char *sBuf = NULL;
	double dVal;

	iRet = CallFdk_Initialize("callfdk.cfg", &tError);
	if (iRet < 0) {
		printf("Error: %s\n", tError.sErrText);
		return -1;
	}

	pIn = MSG_GetNewMsg(MSG_IrNoteVanilla, &tError);
	if (pIn == NULL) {
		printf("Error: pIn: %s\n", tError.sErrText);
		return -1;
	}
	pSub = MSG_GetNewMsg(MSG_IrNotionalInfo, &tError);
	if (pSub == NULL) {
		printf("Error: pSub: %s\n", tError.sErrText);
		return -1;
	}
	iRet = MSG_SetDbl(pSub, TAG_dNotionAmt, 100000);
	if (iRet < 0) {
		printf("Error: %s\n", MSG_GetLastError(pSub));
		MSG_Destroy(pIn);
		MSG_Destroy(pSub);
		return -1;
	}
	iRet = MSG_SetStr(pSub, TAG_sCcy, "USD");
	if (iRet < 0) {
		printf("Error: %s\n", MSG_GetLastError(pSub));
		MSG_Destroy(pIn);
		MSG_Destroy(pSub);
		return -1;
	}

	for (i = 0; i < 3; i++) {
		pAmort = MSG_GetNewMsg(MSG_IrAmortSchedule, &tError);
		if (pAmort == NULL) {
			printf("Error: pAmort: %s\n", tError.sErrText);
			MSG_Destroy(pIn);
			MSG_Destroy(pSub);
			MSG_Destroy(pAmort);
			return -1;
		}
		iRet = MSG_SetInt(pAmort, TAG_iPeriodNo, i+1);
		if (iRet < 0) {
			printf("Error: %s\n", MSG_GetLastError(pSub));
			MSG_Destroy(pIn);
			MSG_Destroy(pSub);
			MSG_Destroy(pAmort);
			return -1;
		}
		iRet = MSG_SetDbl(pAmort, TAG_dAmortAmt, 30000 * (i+1));
		if (iRet < 0) {
			printf("Error: %s\n", MSG_GetLastError(pSub));
			MSG_Destroy(pIn);
			MSG_Destroy(pSub);
			MSG_Destroy(pAmort);
			return -1;
		}
		iRet = MSG_SetSub(pSub, TAG_maIrAmortSchedule, pAmort);
		if (iRet < 0) {
			printf("Error: %s\n", MSG_GetLastError(pSub));
			MSG_Destroy(pIn);
			MSG_Destroy(pSub);
			MSG_Destroy(pAmort);
			return -1;
		}
	}
	iRet = MSG_SetSub(pIn, TAG_mIrNotionalInfo, pSub);
	if (iRet < 0) {
		printf("Error: %s\n", MSG_GetLastError(pSub));
		MSG_Destroy(pIn);
		MSG_Destroy(pSub);
		return -1;
	}

	MSG_Dump(pIn, NULL, NULL);

	pOut = MSG_GetNewMsg(MSG_IrNoteOut, &tError);
	if (pOut == NULL) {
		printf("Error: pOut: %s\n", tError.sErrText);
		MSG_Destroy(pIn);
		return -1;
	}

	iRet = CallFdk_CallService(2106, pIn, pOut, &tError);
	if (iRet < 0) {
		printf("Error: %s\n", tError.sErrText);
		MSG_Destroy(pIn);
		MSG_Destroy(pOut);
		return -1;
	}
	MSG_Destroy(pIn);

	MSG_Dump(pOut, NULL, NULL);

	iArrSize = MSG_GetArrSize(pOut, TAG_maIrNotePrice);
	for (i = 0; i < iArrSize; i++) {
		pSub = MSG_GetAtSubArr(pOut, TAG_maIrNotePrice, i, &iRet);
		if (pSub == NULL) {
			printf("Error: %s\n", MSG_GetLastError(pOut));
			MSG_Destroy(pOut);
			return -1;
		}
		sBuf = MSG_GetStrEx(pSub, TAG_sPriceType, &iRet);
		if (sBuf == NULL) {
			printf("Error: %s\n", MSG_GetLastError(pSub));
			MSG_Destroy(pOut);
			return -1;
		}
		printf("maIrNotePrice[%d].sPriceType : %s\n", i, sBuf);
		free(sBuf);
		iRet = MSG_GetDbl(pSub, TAG_dDirtyPrice, &dVal);
		if (iRet < 0) {
			printf("Error: %s\n", MSG_GetLastError(pSub));
			MSG_Destroy(pOut);
			return -1;
		}
		printf("maIrNotePrice[%d].dDirtyPrice : %e\n", i, dVal);

	}

	MSG_Destroy(pOut);

	return 0;
}

