#ifndef __CALLFDK_C_H__
#define __CALLFDK_C_H__

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef WIN32
#include <Windows.h>
#include <io.h>

#ifdef V2_DLL_EXPORTS
#define V2_DLL_API __declspec(dllexport)
#else
#define V2_DLL_API __declspec(dllimport)
#endif

#else

#define V2_DLL_API
#define __stdcall

#endif /* WIN32 */

#ifdef __cplusplus
extern "C" {
#endif

typedef void TMsg;

#define CF_ERRTEXT_SIZE	1023

#define V2_True		1
#define V2_False	0

typedef struct {
	int iCode;
	char sErrText[CF_ERRTEXT_SIZE+1];
	int iRefSvcNum;
} CallFdk_Error;

V2_DLL_API int __stdcall CallFdk_Initialize(const char *p_sCfgFile, CallFdk_Error *p_pError);
V2_DLL_API int __stdcall CallFdk_InitializeEx(const char *p_sKeyFile, const char *p_sMsgDicFile,
		const char *p_sServer, int p_iPort, int p_iTimeOut, CallFdk_Error *p_pError);
V2_DLL_API int __stdcall CallFdk_CallService(int p_iSvcNum, TMsg *p_pIn, TMsg *p_pOut, CallFdk_Error *p_pError);

V2_DLL_API TMsg *__stdcall MSG_GetNewMsg(int p_iMsgNum, CallFdk_Error *p_pError);
V2_DLL_API void __stdcall MSG_Destroy(TMsg *p_pMsg);
V2_DLL_API int __stdcall MSG_GetSelfNum(TMsg *p_pMsg);

// Set
V2_DLL_API int __stdcall MSG_SetInt(TMsg *p_pMsg, int p_iTagNum, int p_iValue);
V2_DLL_API int __stdcall MSG_SetDbl(TMsg *p_pMsg, int p_iTagNum, double p_dValue);
V2_DLL_API int __stdcall MSG_SetStr(TMsg *p_pMsg, int p_iTagNum, char *p_sValue);
V2_DLL_API int __stdcall MSG_SetBool(TMsg *p_pMsg, int p_iTagNum, int p_bValue);
V2_DLL_API int __stdcall MSG_SetDate(TMsg *p_pMsg, int p_iTagNum, char *p_sDate);
V2_DLL_API int __stdcall MSG_SetSub(TMsg *p_pMsg, int p_iTagNum, TMsg *p_pSub);

//Get
V2_DLL_API int __stdcall MSG_GetStrLen(TMsg *p_pMsg, int p_iTagNum);
V2_DLL_API int __stdcall MSG_GetStr(TMsg *p_pMsg, int p_iTagNum, char *p_sVal);
V2_DLL_API int __stdcall MSG_GetInt(TMsg *p_pMsg, int p_iTagNum, int *p_iVal);
V2_DLL_API int __stdcall MSG_GetDbl(TMsg *p_pMsg, int p_iTagNum, double *p_dVal);
V2_DLL_API int __stdcall MSG_GetBool(TMsg *p_pMsg, int p_iTagNum, int *p_bVal);
V2_DLL_API int __stdcall MSG_GetDate(TMsg *p_pMsg, int p_iTagNum, char *p_sDate);
V2_DLL_API TMsg *__stdcall MSG_GetSub(TMsg *p_pMsg, int p_iTagNum, int *p_pErrCode);
V2_DLL_API char *__stdcall MSG_GetStrEx(TMsg *p_pMsg, int p_iTagNum, int *p_pErrCode);

V2_DLL_API int __stdcall MSG_GetArrSize(TMsg *p_pMsg, int p_iTagNum);
V2_DLL_API int __stdcall MSG_GetAtStrLen(TMsg *p_pMsg, int p_iTagNum, int p_iIdx);
V2_DLL_API int __stdcall MSG_GetAtStrArr(TMsg *p_pMsg, int p_iTagNum, int p_iIdx, char *p_sVal);
V2_DLL_API int __stdcall MSG_GetAtIntArr(TMsg *p_pMsg, int p_iTagNum, int p_iIdx, int *p_iVal);
V2_DLL_API int __stdcall MSG_GetAtDblArr(TMsg *p_pMsg, int p_iTagNum, int p_iIdx, double *p_dVal);
V2_DLL_API int __stdcall MSG_GetAtBoolArr(TMsg *p_pMsg, int p_iTagNum, int p_iIdx, int *p_bVal);
V2_DLL_API int __stdcall MSG_GetAtDateArr(TMsg *p_pMsg, int p_iTagNum, int p_iIdx, char *p_sDate);
V2_DLL_API TMsg *__stdcall MSG_GetAtSubArr(TMsg *p_pMsg, int p_iTagNum, int p_iIdx, int *p_pErrCode);
V2_DLL_API char *__stdcall MSG_GetAtStrArrEx(TMsg *p_pMsg, int p_iTagNum, int p_iIdx, int *p_pErrCode);

V2_DLL_API char *__stdcall MSG_GetLastError(TMsg *p_pMsg);

V2_DLL_API int __stdcall MSG_Dump(TMsg *p_pMsg, const char *p_sFileName, CallFdk_Error *p_pError);


#ifdef __cplusplus
}
#endif

#endif	/* __CALLFDK_C_H__ */
